% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabsel_thr.R
\name{stabsel_thr}
\alias{stabsel_thr}
\title{Tuning the probability threshold.}
\usage{
stabsel_thr(stabsel = NULL, data = NULL, model = NULL,
  est_model = NULL, prob = NULL, nm = NULL, pars.pen = NULL,
  from = 0.5, to = 1, jump = 0.01, method = "aic")
}
\arguments{
\item{stabsel}{output object from stabsel function. If specified, data, model, est_model, prob, nm, and pars.pen parameters are not needed.}

\item{data}{data frame}

\item{model}{lavaan syntax model.}

\item{est_model}{lavaan output object.}

\item{prob}{matrix of selection probabilities.}

\item{nm}{names(regsemOutput$coefficients).}

\item{pars.pen}{a vector of numbers corresponding to paths to be removed (same sequence as regsemOutput$coefficients).}

\item{from}{starting value of the threshold parameter.}

\item{to}{end value of the threshold parameter.}

\item{jump}{increment of the threshold parameter.}

\item{method}{fit indices uesd to tune the parameter.}
}
\value{
rtn results using the optimal threshold.
}
\description{
This function tune the probability threshold parameter.
}
