# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from apache_openid.utils.baseutil import BaseUtil


DONE = -2
HTTP_FORBIDDEN = 403
HTTP_MOVED_TEMPORARILY = 302
OK = 0


class SERVER_RETURN(Exception):
    pass


class FieldStorage(object):

    def __init__(self, req):
        self.request = req

    def getfirst(self, key, default=None):
        return default

    def keys(self):
        return []


class Options(object):
    defaults = {}

    def __init__(self, overrides=None):
        if overrides is None:
            overrides = {}
        self.overrides = overrides

    def __getitem__(self, index):
        value = self.overrides.get(index)
        if value is not None:
            return value
        else:
            return self.defaults[index]

    def __setitem__(self, index, value):
        self.overrides[index] = value

    def __delitem__(self, index):
        del self.overrides[index]

    def __len__(self):
        return len(self.overrides)

    def __contains__(self, item):
        return item in self.overrides
    
    def get(self, index, default=None):
        try:
            return self.__getitem__(index)
        except KeyError:
            return default


class ApacheMockRequest(object):

    def __init__(self):
        self.buf = ''
        self.content_type = None
        self.headers_out = {}
        self.hostname = 'localhost'
        self.method = 'GET'
        self.subprocess_env = {
            'REQUEST_URI': '',
        }

    def connection(self):
        pass
    connection.local_addr = ('localhost', '80')
    
    def hlist(self):
        pass
    hlist.location = None

    def is_https(self):
        return False

    def set_content_length(self, length):
        pass

    def write(self, string):
        self.buf = string


class Session(dict):

    def save(self):
        pass


def add_cookie(req, cookie, value='', **kw):
    pass


def get_cookies(req):
    cookies = {}
    return cookies


def log_error(error_string):
    print "log_error(): %s" % error_string


class MockUtil(BaseUtil):

    def cls_field_storage(self):
        return FieldStorage

    def cls_session(self):
        return Session

    def const_done(self):
        return DONE

    def const_http_forbidden(self):
        return HTTP_FORBIDDEN

    def const_http_moved_temporarily(self):
        return HTTP_MOVED_TEMPORARILY

    def const_ok(self):
        return OK

    def const_server_return(self):
        return SERVER_RETURN

    def func_add_cookie(self):
        return add_cookie

    def func_get_cookies(self):
        return get_cookies

    def func_log_error(self):
        return log_error
