/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SHARING-ADAPTOR_H
#define SHARING-ADAPTOR_H

#include <QtCore/QObject>
#include <QtDBus/QtDBus>
QT_BEGIN_NAMESPACE
class QByteArray;
template<class T> class QList;
template<class Key, class Value> class QMap;
class QString;
class QStringList;
class QVariant;
QT_END_NAMESPACE

/*
 * Adaptor class for interface org.ukui.SettingsDaemon.Sharing
 */
class SharingAdaptor: public QDBusAbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.SettingsDaemon.Sharing")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.ukui.SettingsDaemon.Sharing\">\n"
"    <signal name=\"serviceChange\">\n"
"      <arg direction=\"out\" type=\"s\" name=\"state\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"serviceName\"/>\n"
"    </signal>\n"
"    <method name=\"EnableService\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"serviceName\"/>\n"
"    </method>\n"
"    <method name=\"DisableService\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"serviceName\"/>\n"
"    </method>\n"
"  </interface>\n"
        "")
public:
    SharingAdaptor(QObject *parent);
    virtual ~SharingAdaptor();

public: // PROPERTIES
public Q_SLOTS: // METHODS
    void DisableService(const QString &serviceName);
    void EnableService(const QString &serviceName);
Q_SIGNALS: // SIGNALS
    void serviceChange(const QString &state, const QString &serviceName);
};

#endif
