//<-- CLI SHELL MODE -->
// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2012 - SE - Sylvestre Ledru
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
A=testmatrix("magi",5);
[Q,R,JPVT,RANK,SVAL]=rankqr(A,%eps);
assert_checkequal(RANK, 5);
assert_checkequal(JPVT, [3,1,4,2,5]);
assert_checkalmostequal(SVAL, [64.612618,13.836178,13.836178], 1e-6);

R_ref=[-34.71311,-20.021254,-23.478161,-23.478161,-20.021254;
0,-25.576344,-11.727155,-15.441525,-17.170139;
0,0,-20.4022,3.0540446,-9.4882354;
0,0,0,17.493086,3.6461334;
0,0,0,0,16.000463];
assert_checkalmostequal(R, R_ref, 1e-6);

Q_ref=[-0.0288076,-0.6421260,0.0101293,0.7647199,0.0441038;
-0.2016529,-0.7414138,-0.0279815,-0.6343960,0.0800023;
-0.3744983,0.1367641,-0.6279383,0.0707175,0.6646346;
-0.5473436,0.0374763,-0.4209775,0.0579516,-0.7200208;
-0.720189,0.1336816,0.6539005,0.0662258,0.1774410];
assert_checkalmostequal(Q, Q_ref, 1e-5);
