<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<!--
     This file contains a template for including the CSS definition
     used by the HTML output XSL transforms. (The CSS definition was
     originally designed by Oskar Ojala.)

     Copyright © 2005,2011 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
-->

<xsl:output method="xml" indent="yes"
   doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
   doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

<!--
     The direct approach for including the stylesheet is to include 
     a line such as

       <link href="cssinc.css" rel="stylesheet" type="text/css"/>

     within the <head> element of the HTML output. Since O. Ojala 
     notes that browser support for this is still somewhat limited,
     the alternative approach used here is to call a named template,
     defined in an included XSL, which defines the CSS style.
-->

<xsl:template name="include-stylesheet">
  <xsl:param name="font-size">11</xsl:param>
  <style type="text/css">
    body  {
      margin-left: 2%;
      margin-right: 2%;
      margin-top: 1%;
      margin-bottom: 5%;
      font-family: sans-serif;
      font-size: <xsl:value-of select="$font-size"/>pt;
      color: black;
      background-color: rgb(255,255,255);
    }
    table {
      border: solid;
      border-width: 2px;
      width: 100%;
      border-collapse: collapse;
      margin-left: auto;
      margin-right: auto;
    }
    table.nb {
      border-width: 0px;
    }
    tr {
      vertical-align: top;
    }
    td {
      font-family: sans-serif;
      font-size: <xsl:value-of select="$font-size"/>pt;
      color: black;
      background-color: rgb(248,248,248);
      border: 1px solid black;
      padding-left: 4px;
      padding-right: 4px;
    }
    td.plain {
      border-width: 0px;
    }
    th {
      font-family: sans-serif;
      font-size: <xsl:value-of select="$font-size"/>pt;
      font-weight: bold;
      color: black;
      background-color: rgb(235,235,235);
      border: 1px solid black;
    }
    .gtitle {
      text-align: center;
      font-size: 170%;
      padding-bottom: 0.4em;
    }
    .gid {
      font-style: italic;
    }
    .fn {
      margin-left: 6px;
      font-style: italic;
      font-size: 85%;
      color: #ffb31a;
    }
    .gc {
      font-style: italic;
      font-size: 85%;
      padding-left: 1em;
    }
    .cblock {
      margin-left: 18%;
      margin-right: 18%;
      padding-top: 4px;
      padding-bottom: 4px;
    }
    .citem {
      font-size: 115%;
      font-style: italic;
      padding-left: 0.6em;
      padding-right: 0.6em;
    }
    .gend {
      padding-bottom: 3em;
    }
    .left {
      text-align : left;
    }
    .center {
      text-align: center;
    }
    .right {
      text-align: right;
    }
    a {
      text-decoration: none;
      color: #2e5c89;
    } 
    a:hover {
      color: #247cd2;
    }
  </style>
</xsl:template>

</xsl:stylesheet>
