/*  BEGIN software license
 *
 *  msXpertSuite - mass spectrometry software suite
 *  -----------------------------------------------
 *  Copyright(C) 2009, 2017 Filippo Rusconi
 *
 *  http://www.msxpertsuite.org
 *
 *  This file is part of the msXpertSuite project.
 *
 *  The msXpertSuite project is the successor of the massXpert project. This
 *  project now includes various independent modules:
 *  
 *  - massXpert, model polymer chemistries and simulate mass spectrometric data;
 *  - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * END software license
 */



#pragma once


/////////////////////// Qt includes
#include <QObject>


/////////////////////// Local includes
#include "ui_SqlMassDataSlicerDlg.h"
#include <minexpert/nongui/SqlMassDataSlicer.hpp>
#include <minexpert/nongui/globals.hpp>

namespace msXpSmineXpert
{


	//! The SqlMassDataSlicerDlg class provides an iterface to configure the slicing of files.
	class SqlMassDataSlicerDlg : public QDialog
	{
		Q_OBJECT

		private:

			//! Graphical user interface definition.
			Ui::SqlMassDataSlicerDlg m_ui;

			//! Name of the application to display in the window title.
			QString m_applicationName;

			//! Pointer to the SqlMassDataSlicer instance to use for the slicing operation.
			SqlMassDataSlicer *mp_slicer = nullptr;

		public:

			void initialize();
			void setSrcFileName(const QString &fileName);
			void setRangeStart(double start);
			void setRangeEnd(double end);
			void setRangeLimits(double start, double end);

			void readSettings();
			void writeSettings();

			SqlMassDataSlicerDlg(QWidget *parent, SqlMassDataSlicer *slicer,
					const QString &applicationName);
			~SqlMassDataSlicerDlg();

			void reviewFileNames();

			void setupFeedback(QString msg, int startValue, int endValue,
					int currentValue = -1);
			void updateFeedback(QString msg, int currentValue);
			
			void updateSliceFileName(QString fileName);

			void validatePushButton();
			void closePushButton();
			void confirmPushButton();
			void destDirectoryPushButton();
			void displayedRegionCheckBoxStateChanged(int checkState);
			void sliceRadioButtonToggled(bool checked);
	};

} // namespace msXpSmineXpert

