/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBUNTU_HUD_HUD_H
#define UBUNTU_HUD_HUD_H

#include <QObject>

#include "context.h"

namespace Ubuntu {
namespace HUD {
    class HUD;
}
}

class Ubuntu::HUD::HUD : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(HUD)

    class Private;

public:
    HUD(QObject *parent = 0);
    virtual ~HUD();

    QList<Context *> contexts();
    Q_INVOKABLE void setActiveContext(Context *context);

    void _register(const QString &application_idenfier);

    /*! adds a HUD Context */
    Q_INVOKABLE void addContext(Context *context);
    Q_INVOKABLE void removeContext(Context *context);


signals:
    void contextsChanged();

    void contextAdded(Context *context);
    void contextRemoved(Context *context);

private:
    Private *d;
};

#endif // UBUNTU_HUD_HUD_H
