/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "context.h"

using namespace Ubuntu::HUD;

/*!
 * \qmltype Context
 * \instantiates Context
 * \since 1.0
 */

/*!
 * \qmlproperty list Context::actions
 *
 * actions registered to HUD
 */

QML::Context::Context(QObject *parent)
    : Ubuntu::HUD::Context(parent)
{
}

QML::Context::~Context()
{

}

QQmlListProperty<Ubuntu::HUD::Action>
QML::Context::actions_list()
{
    return QQmlListProperty<Ubuntu::HUD::Action>(this,
                                                 0,
                                                 &QML::Context::append,
                                                 &QML::Context::count,
                                                 &QML::Context::at,
                                                 &QML::Context::clear);
}

void
QML::Context::append(QQmlListProperty<Ubuntu::HUD::Action> *list,
                     Ubuntu::HUD::Action *action)
{
    QML::Context *self = qobject_cast<QML::Context *>(list->object);
    if (self)
        self->addAction(action);
}

Ubuntu::HUD::Action *
QML::Context::at(QQmlListProperty<Ubuntu::HUD::Action> *list,
                 int index)
{
    QML::Context *self = qobject_cast<QML::Context *>(list->object);
    if (self)
        return self->actions().at(index);
    Q_ASSERT(0); // should never reach here
    return 0;
}

void
QML::Context::clear(QQmlListProperty<Ubuntu::HUD::Action> *list)
{
    QML::Context *self = qobject_cast<QML::Context *>(list->object);
    if (self) {
        QList<Ubuntu::HUD::Action *> actions = self->actions();
        foreach(Ubuntu::HUD::Action *action, actions) {
            self->removeAction(action);
        }
    }
}

int
QML::Context::count(QQmlListProperty<Ubuntu::HUD::Action> *list)
{
    QML::Context *self = qobject_cast<QML::Context *>(list->object);
    if (self)
        return self->actions().count();
    Q_ASSERT(0); // should never reach here
    return 0;
}
