# splitmix

Pure Haskell implementation of SplitMix pseudo-random number generator.

## dieharder

> [Dieharder](http://webhome.phy.duke.edu/~rgb/General/dieharder.php) is a random
number generator (rng) testing suite. It is intended to test generators, not
files of possibly random numbers as the latter is a fallacious view of what it
means to be random. Is the number 7 random? If it is generated by a random
process, it might be. If it is made up to serve the purpose of some argument
(like this one) it is not. Perfect random number generators produce "unlikely"
sequences of random numbers &ndash; at exactly the right average rate. Testing a rng
is therefore quite subtle.

```
time $(cabal-plan list-bin splitmix-dieharder) splitmix
```

The test-suite takes around half-an-hour to complete.
From 30 runs, 2.49% were weak (3247 passed, 83 weak, 0 failed).

In comparison, built-in [Marsenne Twister](https://en.wikipedia.org/wiki/Mersenne_Twister)
test takes around 15min.

```
time dieharder -a
```

## benchmarks

```
benchmarking list 64/random
time                 1.317 ms   (1.303 ms .. 1.335 ms)
                     0.998 R²   (0.998 R² .. 0.999 R²)
mean                 1.380 ms   (1.365 ms .. 1.411 ms)
std dev              70.83 μs   (37.26 μs .. 131.8 μs)
variance introduced by outliers: 39% (moderately inflated)

benchmarking list 64/tf-random
time                 141.1 μs   (140.4 μs .. 142.1 μs)
                     0.999 R²   (0.998 R² .. 1.000 R²)
mean                 145.9 μs   (144.6 μs .. 150.4 μs)
std dev              7.131 μs   (3.461 μs .. 14.75 μs)
variance introduced by outliers: 49% (moderately inflated)

benchmarking list 64/splitmix
time                 17.86 μs   (17.72 μs .. 18.01 μs)
                     0.999 R²   (0.998 R² .. 1.000 R²)
mean                 17.95 μs   (17.75 μs .. 18.47 μs)
std dev              1.000 μs   (444.1 ns .. 1.887 μs)
variance introduced by outliers: 64% (severely inflated)

benchmarking tree 64/random
time                 800.3 μs   (793.3 μs .. 806.5 μs)
                     0.999 R²   (0.998 R² .. 0.999 R²)
mean                 803.2 μs   (798.1 μs .. 811.2 μs)
std dev              22.09 μs   (14.69 μs .. 35.47 μs)
variance introduced by outliers: 18% (moderately inflated)

benchmarking tree 64/tf-random
time                 179.0 μs   (176.6 μs .. 180.7 μs)
                     0.999 R²   (0.998 R² .. 0.999 R²)
mean                 172.7 μs   (171.3 μs .. 174.6 μs)
std dev              5.590 μs   (4.919 μs .. 6.382 μs)
variance introduced by outliers: 29% (moderately inflated)

benchmarking tree 64/splitmix
time                 51.54 μs   (51.01 μs .. 52.15 μs)
                     0.999 R²   (0.998 R² .. 0.999 R²)
mean                 52.50 μs   (51.93 μs .. 53.55 μs)
std dev              2.603 μs   (1.659 μs .. 4.338 μs)
variance introduced by outliers: 55% (severely inflated)
```

Note: the performance can be potentially further improved when GHC gets
[SIMD Support](https://ghc.haskell.org/trac/ghc/wiki/SIMD/Implementation/Status).
