/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2010 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <png.h>

typedef struct {

	gint32 width;
	gint32 height;
	gint32 rowbytes;
	gint32 channels;

	gint32 bit_depth;
	gint32 color_type;

	gint32 size;
	gint32 size_image;
	gint32 size_alpha;
	gboolean have_alpha;
	gboolean available_alpha;
	gint32 nb_pixel;

	guint8 *image;
	gboolean image_allocated;
	gboolean image_need;
	guint8 *alpha;
	gboolean alpha_allocated;
	gboolean alpha_need;

	guint8 *part_image;
	guint8 *part_alpha;

} _png_imagedata;


gboolean readpng_init(FILE *infile, png_structp *png_struct, png_infop *png_info, _png_imagedata *png_imagedata);
gboolean readpng_decode_image(png_structp *png_struct, png_infop *png_info, _png_imagedata *png_imagedata, gboolean get_alpha);
guint8 *readpng_get_image(_png_imagedata *png_imagedata);
guint8 *readpng_get_alpha(_png_imagedata *png_imagedata);
guint8 *readpng_get_image_zone(_png_imagedata *png_imagedata, gint32 x, gint32 y, gint32 width, gint32 height);
guint8 *readpng_get_alpha_zone(_png_imagedata *png_imagedata, gint32 x, gint32 y, gint32 width, gint32 height);
void readpng_cleanup(png_structp *png_struct, png_infop *png_info, _png_imagedata *png_imagedata);
