# Related Work

## Support Projects

* [SQLite]: C-language library that implements a small, fast,
  self-contained, high-reliability, full-featured, SQL database engine
* [pikchr]: PIC-like markup language for diagrams in technical
  documentation
* [althttpd]: simple, secure, and low resource usage webserver
  that has run the https://sqlite.org/ website since 2004
* [Lemon Parser Generator][lemon]: re-entrant and thread-safe
  LALR(1) parser with a less error-prone grammar syntax than YACC or BISON
* [Makeheaders]: automatically generate header files for C/C++ projects

## Fossil Inspired Projects

* [libfossil]: 3rd party Fossil SCM Library API
* [fnc]: interactive text-based user interface for Fossil
* [ChiselApp]: Free Fossil SCM hosting!
* [Inskinerator]: The Fossil Skin Generator
* [Fuel]: cross-platform GUI front-end for the excellent Fossil SCM
* [fsl]: Tcl/Expect wrapper script extending Fossil functionality


## Editor Plugins

* [Emacs-Fossil][emacsfsl]: GNU Emacs VC backend for the Fossil version
  control system
* [VS Code][vscode]: Integrated Fossil source control in Visual Studio Code
* [Qt Creator Plugin][qtfsl]: Fossil SCM plugin for the Qt Creator IDE
* [Jetbrains IDE Plugin][jetbrains]: Fossil SCM plugin for [CLion], [IntelliJ],
  [GoLand], and more
* [NetBeans Plugin][netbeans]: NetBeans plugin module to use Fossil SCM

## Version Control/Software Configuration Management

* [Git]: Free and open source distributed version control system
* [Subversion]: Apache's open source version control system
* [Mercurial]: free, distributed source control management tool
* [Game of Trees][got]: version control which prioritizes ease of use and
  simplicity over flexibility
* [Darcs]: free and open source, cross-platform version control system
* [Pijul]: patch-based distributed version control system
* [Sapling]: A Scalable, User-Friendly Source Control System

## Podcasts

* [Corecursive #066][corec66]: The Untold Story of SQLite
* [The Changelog #454][changelog454]: Richard Hipp returns
* [The Changelog #201][changelog201]: Why SQLite succeeded as a database
* [bsdtalk194][bsdtalk]: Interview with D. Richard Hipp
* [Two Weeks of Databases][db2w]: Richard Hipp interviewed by Federico Razzoli
* [Software Engineering Daily][swed]: SQLite with D. Richard Hipp
* [Floss Weekly 26][floss26]: Interview with D. Richard Hipp, creator of SQLite

## Miscellany

* [Tcl]: a simple-to-learn yet very powerful programming language

[althttpd]:      https://sqlite.org/althttpd/doc/trunk/althttpd.md
[bsdtalk]:       https://bsdtalk.blogspot.com/2010/07/bsdtalk194-fossil-scm-with-d-richard.html
[changelog201]:  https://changelog.com/podcast/201
[changelog454]:  https://changelog.com/podcast/454
[ChiselApp]:     https://chiselapp.com/
[CLion]:         https://www.jetbrains.com/clion/
[corec66]:       https://corecursive.com/066-sqlite-with-richard-hipp/
[Darcs]:         http://darcs.net/
[db2w]:          https://youtu.be/2eaQzahCeh4
[emacsfsl]:      https://chiselapp.com/user/venks/repository/emacs-fossil/doc/tip/README.md
[floss26]:       https://twit.tv/shows/floss-weekly/episodes/26
[fnc]:           https://fnc.sh
[fsl]:           http://fossil.0branch.com/fsl
[Fuel]:          https://fuel-scm.org/fossil/index
[Git]:           https://git-scm.com
[GoLand]:        https://www.jetbrains.com/go/
[got]:           https://gameoftrees.org
[Inskinerator]:  https://tangentsoft.com/inskinerator
[IntelliJ]:      https://www.jetbrains.com/idea/
[jetbrains]:     https://plugins.jetbrains.com/plugin/7479-fossil-integration
[lemon]:         https://www.hwaci.com/sw/lemon/
[libfossil]:     https://fossil.wanderinghorse.net/r/libfossil/wiki/home
[Makeheaders]:   https://fossil-scm.org/home/doc/trunk/tools/makeheaders.html
[Mercurial]:     https://www.mercurial-scm.org/
[netbeans]:      https://chiselapp.com/user/backendzeit/repository/netbeans-fossil-plugin/index
[Pijul]:         https://pijul.org
[pikchr]:        https://pikchr.org
[qtfsl]:         https://code.qt.io/cgit/qt-creator/plugin-fossil-scm.git/
[Sapling]:       https://sapling-scm.com
[SQLite]:        https://sqlite.org/index.html
[Subversion]:    https://subversion.apache.org/
[swed]:          https://softwareengineeringdaily.com/2015/11/13/sqlite-with-d-richard-hipp/
[Tcl]:           https://core.tcl-lang.org/tcl/wiki?name=Index
[VSCode]:        https://marketplace.visualstudio.com/items?itemName=koog1000.fossil
