/*
    DualWord-RT : https://github.com/dualword/dualword-rt

    Copyright (C) 2015-2025 Alexander Busorgin

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "DualwordRT.h"
#include "MainWindow.h"

DualwordRT::DualwordRT(int &argc, char **argv) : QApplication(argc, argv) {
	QCoreApplication::setApplicationName("Dualword-RT");
    QCoreApplication::setOrganizationName("dualword-rt");
    QCoreApplication::setOrganizationDomain("dualword-rt");

	#ifdef _VER
		QApplication::setApplicationVersion(_VER);
	#endif

	QApplication::setQuitOnLastWindowClosed(true);
	QCoreApplication::thread()->setPriority(QThread::HighestPriority);
    setWindowIcon(QIcon(":/dualword-rt.ico"));

}

DualwordRT::~DualwordRT() {

}

void DualwordRT::start() {
	win.reset(new MainWindow());
	win->init();
    win->showMaximized();
}


void DualwordRT::setValue(const QString &key, const QVariant& val){
    QSettings s;
    s.setValue(key, val);
}

QVariant DualwordRT::value(const QString &key, const QVariant& val){
    QSettings s;
    return s.value(key, val);
}
